
# 🚀 Deployment Guide for Namecheap

## Step 1: Prepare Your Files
1. Ensure all your files are ready. 
   - A zip file `deployment_package.zip` has been created for you in this folder (run the python script if not present).

## Step 2: Database Setup (Namecheap)
1. Log in to **Namecheap cPanel**.
2. Go to **MySQL Database Wizard**.
3. Create a new database (e.g., `rachid_website`).
4. Create a new user and password. **Note these down!**
5. Assign the user to the database with **ALL PRIVILEGES**.
6. Go to **phpMyAdmin** in cPanel.
7. Select your new database.
8. Click **Import**.
9. Upload the `database.sql` file from your local folder.

## Step 3: Upload Files
1. Go to **File Manager** in cPanel.
2. Navigate to `public_html` (or your subdomain folder).
3. Click **Upload** and select `deployment_package.zip`.
4. Right-click the zip file and choose **Extract**.
5. Move the extracted files to the main folder if they are in a subfolder.

## Step 4: Connect Database
1. In File Manager, edit the `db.php` file.
2. Update the credentials with the ones you created in Step 2:
   ```php
   $host = 'localhost'; // Usually stays 'localhost' on Namecheap
   $username = 'your_cpanel_db_user';
   $password = 'your_cpanel_db_password';
   $dbname = 'your_cpanel_db_name';
   ```
3. Save changes.

## Step 5: Test
- Visit your website URL.
- Try submitting a form.
- Go to `/admin` to log in and check the data.

✅ **Done!** Your site is live.
